CREATE PROCEDURE [dbo].[sp_DeleteBackupHistoryAndFiles] @DaysToKeep smallint = null, @UseLocalTime bit = 0

AS

 BEGIN

 set nocount on

  IF @DaysToKeep IS NULL OR @DaysToKeep <= 0

  RETURN

 	/*
		Only delete full sets
        If a set spans a day such that some items fall into the deleted group and the other don't don't delete the set

		Delete history only if history of full Backup exists at a later point of time
        why: history of full backup is used in sp_BackupAllFull_Schedule to check if full backup of databases is required or not.
		If history of full backup is not present, job will take a full backup irrespective of other options (frequency, Backup hour)
	
    */
		
  declare @PurgeDateTime datetime

  if (@UseLocalTime = 0)
    set @PurgeDateTime = DATEADD(dd, -@DaysToKeep, GETUTCDATE())
  else
    set @PurgeDateTime = DATEADD(dd, -@DaysToKeep, GETDATE())

  DECLARE DeleteBackupFiles CURSOR

  FOR SELECT 'del "' + [BackupFileLocation] +  case right(BackupFileLocation,1) when '\' then '' else '\' end + [BackupFileName] + '"' FROM [adm_BackupHistory] [h1]
	WHERE 	[BackupDateTime] < @PurgeDateTime
	AND	[BackupSetId] NOT IN ( SELECT [BackupSetId] FROM [dbo].[adm_BackupHistory] [h2] WHERE [h2].[BackupSetId] = [h1].[BackupSetId] AND [h2].[BackupDateTime] >= @PurgeDateTime)
	AND EXISTS( SELECT TOP 1 1 FROM [dbo].[adm_BackupHistory] [h2] WHERE [h2].[BackupSetId] > [h1].[BackupSetId] AND [h2].[BackupType] = 'db')

  DECLARE @cmd varchar(400)

  OPEN DeleteBackupFiles

   FETCH NEXT FROM DeleteBackupFiles INTO @cmd

  WHILE (@@fetch_status <> -1)

  BEGIN

            IF (@@fetch_status <> -2)

            BEGIN

                        EXEC master.dbo.xp_cmdshell @cmd, NO_OUTPUT

                        delete from [adm_BackupHistory] WHERE CURRENT OF DeleteBackupFiles

                        print @cmd

            END

            FETCH NEXT FROM DeleteBackupFiles INTO @cmd

  END


  CLOSE DeleteBackupFiles

  DEALLOCATE DeleteBackupFiles


  END

GO

GRANT EXECUTE ON [dbo].[sp_DeleteBackupHistoryAndFiles] TO BTS_BACKUP_USERS
GO
